local t = Def.ActorFrame{};
local tContainer = MetroQuad.Global.MiscOptions.TimerCountDownContainer
t[#t+1] = LoadActor("../_MenuTimer",tContainer)..{InitCommand=cmd(xy,CenterX(),Top()+14;)}

t[#t+1] = LoadActor("BPMDisplay")
t[#t+1] = LoadActor("DifficultyDisplay")
t[#t+1] = LoadActor("Game")
t[#t+1] = LoadActor("OpListQuads")..{InitCommand=cmd(draworder,1);}
t[#t+1] = LoadActor("RadarValues")
t[#t+1] = LoadActor("StepsDisplayFrame")
t[#t+1] = LoadActor("Style")
t[#t+1] = LoadActor("SongTime")
t[#t+1] = LoadActor("TopScores")

for pn in ivalues(GAMESTATE:GetEnabledPlayers()) do
	t[#t+1] = LoadActor("RecordStats",pn)
end

-- Check if P1 is enabled before load Actors.
if IsPlayerEnabled(PLAYER_1) then
	t[#t+1] = LoadActor("DiffListP1")..{ InitCommand=cmd(xy,Left()+12,Top()+120;zoom,1.2); };
	
end

-- Check if P2 is enabled before load Actors.
if IsPlayerEnabled(PLAYER_2) then
	t[#t+1] = LoadActor("DiffListP2")..{ InitCommand=cmd(xy,CenterX()+150,Top()+120;zoom,1.2); };
end

for pn in ivalues(GAMESTATE:GetEnabledPlayers()) do
	t[#t+1] = Def.ActorFrame{
		LoadFont("Common Normal")..{
			Text=ToEnumShortString(pn).." CURRENT EXP:";
			InitCommand=function(self) self:y(Top()+6):zoom(0.5):valign(0):diffuse(PlayerColor(pn)) if pn == PLAYER_1 then self:x(CenterX()-246) else self:x(CenterX()+246) end end;
		};
		LoadFont("Common Normal")..{
			Text=commify(EXPObtained(pn), ",");
			InitCommand=function(self) self:y(Top()+22):zoom(0.5):valign(0) if pn == PLAYER_1 then self:x(CenterX()-246) else self:x(CenterX()+246) end end;
		};
	};
end

local function StepsDisplay(pn)
	local function set(self, player)
		self:SetFromGameState( player );
	end

	local t = Def.StepsDisplay {
		InitCommand=cmd(Load,"StepsDisplay",GAMESTATE:GetPlayerState(pn););
	};

	if pn == PLAYER_1 then
		t.CurrentStepsP1ChangedMessageCommand=function(self) set(self, pn); end;
		t.CurrentTrailP1ChangedMessageCommand=function(self) set(self, pn); end;
	else
		t.CurrentStepsP2ChangedMessageCommand=function(self) set(self, pn); end;
		t.CurrentTrailP2ChangedMessageCommand=function(self) set(self, pn); end;
	end

	return t;
end

for pn in ivalues(PlayerNumber) do
	local MetricsName = "StepsDisplay" .. PlayerNumberToString(pn);
	t[#t+1] = StepsDisplay(pn) .. {
		InitCommand=function(self) self:player(pn); self:name(MetricsName); ActorUtil.LoadAllCommandsAndSetXY(self,Var "LoadingScreen"); end;
		PlayerJoinedMessageCommand=function(self, params)
			if params.Player == pn then
				self:visible(true);
				(cmd(zoom,0;bounceend,0.3;zoom,1))(self);
			end;
		end;
		PlayerUnjoinedMessageCommand=function(self, params)
			if params.Player == pn then
				self:visible(true);
				(cmd(bouncebegin,0.3;zoom,0))(self);
			end;
		end;
	};
end

local ut = Def.ActorFrame{
	BeginCommand=cmd(draworder,200);
	LoadFont("Common Normal")..{
		Name="songArtist";
		InitCommand=cmd(x,CenterX()-84;y,Top()+120+4;zoom,0.4;align,0,0;uppercase,true);
		OffCommand=cmd(decelerate,0.05;addy,900;);
		SetCommand=function(self)
			local song;
			local sub="";
			local art="";
			if GAMESTATE:IsCourseMode() then
			else
				song=GAMESTATE:GetCurrentSong();
				sub=song:GetDisplaySubTitle();
				art=song:GetDisplayArtist();
				self:settext(art);
			end;
		end;
	};
	-- Working as SubTitle
	LoadFont("Common Normal")..{
		Name="songTitle";
		InitCommand=cmd(x,CenterX()-112;y,Top()+120+4;zoom,0.4;halign,0);
		OffCommand=cmd(decelerate,0.05;addy,900);
		SetCommand=function(self)
			local song;
			local tit="";
			if GAMESTATE:IsCourseMode() then
				song=GAMESTATE:GetCurrentCourse();
				tit=song:GetDisplayFullTitle();
				
			else
				song=GAMESTATE:GetCurrentSong();
				tit=song:GetDisplayMainTitle();
			end;
			self:settextf("%s",tit);
		end;
	};
};

local function updateTitle(self)
	local upTit = self:GetChild("songTitle");
	local upArt = self:GetChild("songArtist");
	local curSelection = GAMESTATE:GetCurrentSong();
	local curSelCourse = GAMESTATE:GetCurrentCourse();
	upTit:maxwidth(280);
	upArt:maxwidth(540);
	if curSelection or curSelCourse then
		local song;
		local tit="";
		local sub="";
		local art="";
		if GAMESTATE:IsCourseMode() then
			song=GAMESTATE:GetCurrentCourse();
			tit=song:GetDisplayFullTitle();
		else
			song=GAMESTATE:GetCurrentSong();
			tit=song:GetDisplayMainTitle();
			art=song:GetDisplayArtist();
			
			if song:GetDisplaySubTitle() == "" then
				sub=""
			else
				sub=" - " .. song:GetDisplaySubTitle();
			end
			
			upTit:settext("");
		end;
		upTit:diffuse(color("1,1,1,1"));
		upTit:strokecolor(Color("White"));
		
		upArt:settext(art .. sub);
		upArt:diffuse(color("1,1,1,1"));
		upArt:strokecolor(Color("White"));
	else
		upTit:settext("");
		upArt:settext("");
	end;
end;

ut.InitCommand=cmd(SetUpdateFunction,updateTitle);

t[#t+1] = ut;
t[#t+1] = StandardDecorationFromFileOptional("StageDisplay","StageDisplay");
t[#t+1] = StandardDecorationFromFileOptional("DifficultyDisplay","DifficultyDisplay");

t[#t+1] = Def.ActorFrame{
	LoadActor(THEME:GetPathS("","Common Start"))..{
		OptionsListOpenedMessageCommand=cmd(play);
		OptionsListPushMessageCommand=cmd(play);
		OptionsListPopMessageCommand=cmd(play);
	};
	LoadActor(THEME:GetPathS("","Common Value"))..{
		OptionsListLeftMessageCommand=cmd(play);
		OptionsListRightMessageCommand=cmd(play);
	};
}

if GAMESTATE:IsCourseMode() then
	t[#t+1] = StandardDecorationFromFileOptional("NumCourseSongs","NumCourseSongs")..{
		InitCommand=cmd(uppercase,true);
		SetCommand=function(self)
			local curSelection= nil;
			local sAppend = "";
			if GAMESTATE:IsCourseMode() then
				curSelection = GAMESTATE:GetCurrentCourse();
				if curSelection then
					sAppend = (curSelection:GetEstimatedNumStages() == 1) and "Stage" or "Stages";
					self:visible(true);
					self:settext( curSelection:GetEstimatedNumStages() .. " " .. sAppend);
				else
					self:visible(false);
				end;
			else
				self:visible(false);
			end;
		end;
		CurrentCourseChangedMessageCommand=cmd(playcommand,"Set");
	};
end

t[#t+1] = StandardDecorationFromFileOptional("SortOrder","SortOrderText") .. {
	BeginCommand=cmd(playcommand,"Set");
	SortOrderChangedMessageCommand=cmd(playcommand,"Set";);
	SetCommand=function(self)
		local s = SortOrderToLocalizedString( GAMESTATE:GetSortOrder() or 'SortOrder_Group' );
		self:settext("Sort Mode: " .. s);
		self:maxwidth(240)
		self:playcommand("Sort");
		self:uppercase(true)
		self:halign(1)
	end;
};

local function input(event)
	if event.type == "InputEventType_Release" then return false end
	if event.DeviceInput.button == "DeviceButton_escape" then
		SCREENMAN:GetTopScreen():SetNextScreenName("ScreenSelectMusic") SCREENMAN:GetTopScreen():StartTransitioningScreen("SM_GoToNextScreen")
	end
end

t[#t+1] = Def.ActorFrame{
	BeginCommand=cmd(draworder,999);
	LoadFont("Common Normal")..{
		InitCommand=cmd(xy,CenterX(),CenterY();zoom,0.8;uppercase,true;shadowlength,1);
		ShowPressStartForOptionsCommand=function(self)
			SCREENMAN:GetTopScreen():AddInputCallback(input)
			self:settext("Press &START; For Options\nPress &BACK; To Cancel")
		end;
		ShowEnteringOptionsCommand=function(self)
			self:settext("Entering Options...\nPress &BACK; To Cancel")
		end;
	};
};

t[#t+1] = Def.ActorFrame{
	-- P1
	BeginCommand=cmd(visible,IsPlayerEnabled(PLAYER_1));
	LoadFont("Common Normal") .. {
		Text="LENGTH:";
		InitCommand=cmd(x,Left()+6;y,Top()+90;zoom,0.5;align,0,0;diffuse,color("#A4A4A4"));
	};
	LoadFont("Common Normal") .. {
		Text="BPM:";
		InitCommand=cmd(x,Left()+156;y,Top()+90;zoom,0.5;align,0,0;diffuse,color("#A4A4A4"));
	};
};

t[#t+1] = Def.ActorFrame {
	-- P2
	BeginCommand=cmd(visible,IsPlayerEnabled(PLAYER_2));
	LoadFont("Common Normal") .. {
		Text="LENGTH:";
		InitCommand=cmd(x,Right()-218;y,Top()+90;zoom,0.5;align,1,0;diffuse,color("#A4A4A4"));
	};
	LoadFont("Common Normal") .. {
		Text="BPM:";
		InitCommand=cmd(x,Right()-108;y,Top()+90;zoom,0.5;align,1,0;diffuse,color("#A4A4A4"));
	};
};

t[#t+1] = Def.ActorFrame{
	Def.Quad{
		InitCommand=cmd(draworder,-99;x,CenterX();y,Bottom();valign,1;zoomto,Width(),40);
		OnCommand=function(self) self:diffuse(color(LoadFile("ThemeColor.cfg","Settings"))) end;
		ThemeColorChangedMessageCommand=cmd(playcommand,"On");
	};
	Def.Quad{
		InitCommand=cmd(x,Left()+4+128+8;y,Bottom()-20;align,0,1;zoomto,150,16);
		OnCommand=function(self) self:diffuse(BoostColor(color(LoadFile("ThemeColor.cfg","Settings")),2)) end;
		ThemeColorChangedMessageCommand=cmd(playcommand,"On");
	};
	Def.Quad{
		InitCommand=cmd(x,Right()-4-128-8;y,Bottom()-20;align,1,1;zoomto,150,16);
		OnCommand=function(self) self:diffuse(BoostColor(color(LoadFile("ThemeColor.cfg","Settings")),2)) end;
		ThemeColorChangedMessageCommand=cmd(playcommand,"On");
	};
	Def.Quad{
		Name="SearchTitle";
		InitCommand=cmd(xy,CenterX(),Bottom()-20;zoomto,268,16;valign,1);
		OnCommand=function(self) self:diffuse(BoostColor(color(LoadFile("ThemeColor.cfg","Settings")),2)) end;
		ThemeColorChangedMessageCommand=cmd(playcommand,"On");
	};
	Def.Quad{
		InitCommand=cmd(xy,CenterX(),Bottom();valign,1;setsize,Width(),16;diffuse,Black());
	};
};

return t